/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric.common.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;

public class NeoForgeExtraCodecs {
    public static <A> Codec<A> decodeOnly(Decoder<A> decoder) {
        return Codec.of((Encoder)Codec.unit(() -> {
            throw new UnsupportedOperationException("Cannot encode with decode-only codec! Decoder:" + String.valueOf(decoder));
        }), decoder, (String)("DecodeOnly[" + String.valueOf(decoder) + "]"));
    }

    public static <T> Codec<T> withAlternative(Codec<T> codec, Codec<T> alternative) {
        return new AlternativeCodec<T>(codec, alternative);
    }

    private record AlternativeCodec<T>(Codec<T> codec, Codec<T> alternative) implements Codec<T>
    {
        public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
            DataResult result = this.codec.decode(ops, input);
            return result.error().isEmpty() ? result : this.alternative.decode(ops, input);
        }

        public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
            DataResult result = this.codec.encode(input, ops, prefix);
            return result.error().isEmpty() ? result : this.alternative.encode(input, ops, prefix);
        }

        @Override
        public String toString() {
            return "Alternative[" + String.valueOf(this.codec) + ", " + String.valueOf(this.alternative) + "]";
        }
    }
}

